<?php

namespace Database\Seeders;
use App\Models\Page;
use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Factories\Factory;
use App\Enums\Status;
use Illuminate\Support\Str;
class PageSeeder extends Seeder
{
    public function run()
    {
        $pageArr = [
            'Terms And Conditions',
            'Privacy Policy',
            'Support Policy',
        ];

        $content = [
            "<h2>Introduction</h2>
            <p>These terms and conditions govern your use of our music streaming app. By using our app, you accept these terms and conditions in full. If you disagree with these terms and conditions or any part of these terms and conditions, you must not use our app.</p>

            <h2>Content</h2>
            <p>Our app allows you to stream and access various types of audio content, including music, podcasts, and other audio materials.</p>

            <h2>Use of our App</h2>
            <p>You may use our app only for lawful purposes and in accordance with these terms and conditions. You agree not to use our app:</p>
            <ul>
                <li>In any way that violates any applicable federal, state, local, or international law or regulation;</li>
                <li>To transmit, or procure the sending of, any advertising or promotional material, including any 'junk mail,' 'chain letter,' 'spam,' or any other similar solicitation;</li>
                <li>To impersonate or attempt to impersonate us, our employees, another user, or any other person or entity;</li>
                <li>To engage in any other conduct that restricts or inhibits anyone's use or enjoyment of the app, or which, as determined by us, may harm us or users of the app or expose them to liability.</li>
            </ul>

            <h2>Intellectual Property</h2>
            <p>The app and its entire contents, features, and functionality are owned by us or our licensors and are protected by international copyright, trademark, patent, trade secret, and other intellectual property or proprietary rights laws.</p>

            <h2>Limitations of Liability</h2>
            <p>We will not be liable for any damages of any kind arising out of or in connection with your use of the app, including but not limited to direct, indirect, incidental, punitive, and consequential damages.</p>

            <h2>Changes to These Terms and Conditions</h2>
            <p>We reserve the right, at our sole discretion, to modify or replace these terms and conditions at any time. By continuing to use our app after any revisions become effective, you agree to be bound by the updated terms and conditions.</p>

            <h2>Contact Us</h2>
            <p>If you have any questions about these terms and conditions, please contact us.</p>",

            '<strong>Policy Declaration</strong></span></p><p>We are committed to protecting the privacy of our users and have designed this privacy policy to explain how we collect, use, and protect your personal information. By using our services, you consent to the collection and use of your information as described in this policy. We reserve the right to modify this policy at any time, so please review it frequently.</p><p><span style="font-size:22pt"><strong>Data Safety Section</strong></span></p><p>We take the security of your personal information seriously and implement reasonable measures to protect it. We use secure servers and encryption methods to store and transmit data. We also limit access to your personal information to those employees who need it to perform their job functions. However, please note that no method of transmission or storage can be guaranteed to be completely secure, and we cannot guarantee the absolute security of your information.</p><p><span style="font-size:22pt"><strong>Contact Us</strong></span></p><p>If you have any questions or concerns about this privacy policy or our privacy practices, please contact us</p>',

            "<h1>Welcome to our 24/7 support page for our System!</h1>
            <p>We understand that maintaining strong relationships with your customers is crucial to the success of your business. That's why we're here to provide you with uninterrupted assistance whenever you need it.
            <p>Our team of experienced support professionals is available round the clock to address any issues or queries related to our system. Whether you're experiencing technical difficulties, need help with the software's features, or just have a question about how to optimize your customer interactions, we're here to help.</p>
            <p>With our 24/7 support, you can rest assured that we're always here to provide you with prompt and efficient solutions. Our support services are designed to minimize downtime and ensure that your business operations run smoothly at all times.</p>
            <p>In addition to our support team, we also offer a comprehensive knowledge base and user guides to help you navigate our system with ease. Whether you're a new user or an experienced one, our resources are designed to empower you with the knowledge and tools you need to make the most of our software.</p>
            <p>At our site, we're committed to delivering top-notch support to our customers. With our 24/7 support and resources, you can trust us to help you build and maintain strong relationships with your customers.</p>",
        ];

        $privacyPolicy = "
        <p><p class=&quot;condition_description mb_20&quot;>At Landlord, we understand the importance of privacy, especially when it comes to personal information. We are committed to protecting your privacy and ensuring that your personal information is kept secure.  This Privacy Policy describes how we collect, use, and disclose personal information on our website, which is used for rent, buy, and sell properties. Please read this Privacy Policy carefully before using our website or submitting any personal information.</p></p>

<p> <h3 class=&quot;font_30 f_w_700 mb_20 &quot;>Information we collect</h3>  <p class=&quot;condition_description mb_20&quot;>We may collect personal information from you when you use our website, such as your name, email address, phone number, and other contact information. We may also collect information about the properties you are interested in or have viewed, as well as any information you provide when you create an account with us.</p></p>

<p> <h3 class=&quot;font_30 f_w_700 mb_20 &quot;>How we use your information</h3>  <p class=&quot;condition_description mb_20&quot;>We may use your personal information to provide you with information about properties that may be of interest to you, to respond to your inquiries, or to provide customer support. We may also use your personal information to improve our website and services, to analyze trends, and to personalize your experience on our website.</p></p>

<p> <h3 class=&quot;font_30 f_w_700 mb_20 &quot;>Disclosure of your information</h3>  <p class=&quot;condition_description mb_20&quot;>We may disclose your personal information to our third-party service providers who provide us with services such as hosting, data analysis, and customer support. We may also disclose your personal information if required by law or if we believe that such disclosure is necessary to protect our rights, property, or safety, or that of others.</p></p>

<p> <h3 class=&quot;font_30 f_w_700 mb_20 &quot;>Third-party links</h3>  <p class=&quot;condition_description mb_20&quot;>Our website may contain links to third-party websites that are not under our control. We are not responsible for the privacy practices or the content of such websites. We encourage you to read the privacy policies of these third-party websites before providing them with your personal information.</p></p>

<p> <h3 class=&quot;font_30 f_w_700 mb_20 &quot;>Security</h3>  <p class=&quot;condition_description mb_20&quot;>We take reasonable steps to protect your personal information from unauthorized access, use, or disclosure. We use industry-standard encryption technologies to protect your personal information, and our servers are located in secure data centers.</p></p>

<p> <h3 class=&quot;font_30 f_w_700 mb_20 &quot;>Your rights</h3>  <p class=&quot;condition_description mb_20&quot;>You have the right to access, correct, and delete your personal information at any time. You may also withdraw your consent to our use of your personal information. To exercise these rights, please contact us at the email address provided below.</p></p>

<p> <h3 class=&quot;font_30 f_w_700 mb_20 &quot;>Changes to this Privacy Policy</h3>  <p class=&quot;condition_description mb_20&quot;>We may update this Privacy Policy from time to time. We will post the updated Privacy Policy on our website, and we encourage you to review it periodically.</p></p>

<p> <h3 class=&quot;font_30 f_w_700 mb_20 &quot;>Contact Us</h3>  <p class=&quot;condition_description mb_20&quot;>If you have any questions or concerns about this Privacy Policy, please contact us at sales@onettech.com</p></p>";


$data = [];
        $i = 0;
        foreach($pageArr as $page){
            $data[$i]['user_id']        = 2;
            $data[$i]['image_id']       = $i + 1;
            $data[$i]['title']          = $page;
            $data[$i]['slug']           = Str::slug($page);
            $data[$i]['content']        = $i == 1 ? $privacyPolicy : $content[$i]  ;
            $data[$i]['serial']         = $i + 1;
            $data[$i]['status']         = Status::ACTIVE;
            $i++;
        }

        Page::insert($data);
    }
}
