@extends('frontend.layouts.master')

@section('content')
    <!-- checkout_v3_area::start  -->
    <div class="pt-5 pb-5 container">

        @if ($data['carts']->count() > 0)

                    <div class="table-responsive mb-0">
                        <table class="table o_landy_table3 style4 mb-0 table-scrollable">
                            <thead>
                                <tr>
                                    <th class="font_14 f_w_700 m-0 text-nowrap priamry_text">
                                        {{ _trans('landlord.Products') }}
                                    </th>
                                    <th class="font_14 f_w_700 m-0 text-nowrap priamry_text">
                                        {{ _trans('landlord.Price') }}
                                    </th>
                                    <th class="font_14 f_w_700 m-0 text-nowrap priamry_text">
                                        {{ _trans('landlord.Duration') }}
                                    </th>
                                    <th class="font_14 f_w_700 m-0 text-nowrap priamry_text">
                                        {{ _trans('landlord.Total') }}
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($data['carts'] as $cart)
                                    {{-- @dd($cart) --}}
                                    <tr>
                                        <td>
                                            <a href="{{ url('property/' . $cart->property->id . '/details' . '/' . $cart->property->slug) }}"
                                                class="d-flex align-items-center gap_20">
                                                <div class="thumb cart_img overflow-hidden">
                                                    <img class="img-fluid"
                                                        src="{{ url($cart->property->defaultImage->path) }}" alt="">
                                                </div>
                                                <div class="summery_pro_content">
                                                    <h4 class="font_16 f_w_700 text-nowrap m-0 theme_hover">
                                                        {{ @$cart->property->name }}</h4>
                                                    <p class="font_14 f_w_400 m-0 ">{{ @$cart->property->size }}
                                                        {{ _trans('landlord.sqft') }}</p>
                                                </div>
                                            </a>
                                        </td>

                                        <td>
                                            <h4 class="font_16 f_w_500 m-0 text-nowrap rent-amount"
                                                id="rent-amount-{{ $cart->id }}">
                                                ৳{{ @$cart->property->rent_amount }}</h4>
                                        </td>
                                        <td>
                                            <div class="lag_select">
                                                <select class="o_land_select6 min_100 wide"
                                                    data-cart-id="{{ $cart->id }}">
                                                    <option {{ $cart->durations == 1 ? 'selected' : '' }} value="1">1
                                                        month</option>
                                                    <option {{ $cart->durations == 3 ? 'selected' : '' }} value="3">3
                                                        months</option>
                                                    <option {{ $cart->durations == 6 ? 'selected' : '' }} value="6">6
                                                        months</option>
                                                    <option {{ $cart->durations == 12 ? 'selected' : '' }} value="12">12
                                                        months</option>
                                                </select>

                                            </div>
                                        </td>
                                        <td>
                                            <div class="m-0 d-flex gap_10 align-items-center">
                                                <h4 class="font_16 f_w_500 m-0 text-nowrap total-amount"
                                                    id="total-amount-{{ $cart->id }}">
                                                    ৳{{ $cart->durations * $cart->property->rent_amount }}</h4>
                                                <a class="pe-auto cart-delete" data-id="{{ @$cart->id }}">

                                                   <span class="text-danger"><i class="far fa-trash-alt"></i></span>
                                                </a>
                                            </div>
                                        </td>
                                        {{-- <td class="f_w_700">
                                        <div class="m-0 d-flex gap_10 align-items-center">
                                            <h4 class="font_16 f_w_500 m-0 text-nowrap total-amount"
                                            id="total-amount-{{ $cart->id }}">
                                            ৳{{ $cart->property->rent_amount }}</h4>

                                        </div>

                                    </td> --}}
                                    </tr>

                                @empty
                                    <p>{{ _trans('landlord.No property found') }}</p>
                                @endforelse
                            </tbody>
                        </table>
                        <table class="table o_landy_table3 style4 mb-0">
                            <tbody>
                                <tr >
                                    <td colspan="4">
                                        <div class="m-0 d-flex justify-content-end gap_10 align-items-center">

                                                <h4>{{ _trans('landlord.Sub Total') }}</h4>

                                            <div class="single_total_right">
                                                ৳ <span id="updated-amount"> {{ @$data['totalAmount'] }}</span>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="d-flex gap_10 align-items-center flex-wrap mt_20">
                        <div class="d-flex align-items-center gap_10 flex-fill flex-wrap">
                            <a href="{{ route('properties') }}"
                                class="o_land_primary_btn2 style3">{{ _trans('landlord.Add Another Property') }}</a>
                        </div>
                        <a href="{{ route('customer.checkout') }}"
                            class="o_land_primary_btn min_200 style2">{{ _trans('landlord.Checkout') }}</a>
                    </div>

            @else
            <div class="d-flex justify-content-center">
                <p>No Property Found</p>
            </div>
        @endif


        {{-- <div class="checkout_v3_right d-flex justify-content-start">
            <div class="order_sumery_box flex-fill">
                <h3 class="check_v3_title mb_25">{{ _trans('landlord.Order Summary') }}</h3>
                <div class="subtotal_lists">
                    @forelse($data['carts'] as $cart)
                        <div class="single_total_list d-flex align-items-center">
                            <div class="single_total_left flex-fill">
                                <h4>{{ _trans('landlord.Subtotal') }}</h4>
                            </div>
                            <div class="single_total_right">
                                <span> ৳ {{ @$cart->property->rent_amount }}</span>
                            </div>
                        </div>
                        <div class="single_total_list d-flex align-items-center flex-wrap">
                            <div class="single_total_left flex-fill">
                                <h4>{{ _trans('landlord.Shipping Charge') }}</h4>
                                <p>Package Wise Shipping Charge</p>
                            </div>
                            <div class="single_total_right">
                                <span> ৳ {{ @$cart->property->location->upazila->charge }}</span>
                            </div>
                        </div>
                        <div class="single_total_list d-flex align-items-center flex-wrap">
                            <div class="single_total_left flex-fill">
                                <h4>{{ _trans('landlord.Discount') }}</h4>
                            </div>
                            <div class="single_total_right">
                                <span>৳ {{ @$cart->property->discount_amount }}</span>
                            </div>
                        </div>
                        <div class="total_amount d-flex align-items-center flex-wrap">
                            <div class="single_total_left flex-fill">
                                <span class="total_text">{{ _trans('landlord.Total') }} (Incl. VAT)</span>
                            </div>
                            <div class="single_total_right">
                                <span class="total_text">{{ _trans('landlord.USD') }} <span>$1324.35</span></span>
                            </div>
                        </div>
                    @empty
                        <p>{{ _trans('landlord.No property found') }}</p>
                    @endforelse
                </div>
            </div>
        </div> --}}
    </div>
    <!-- checkout_v3_area::end  -->
@endsection

@section('script')
    <script>
        $(document).ready(function() {
            // Listen to changes in the select element
            $('.o_land_select6').on('change', function() {
                // Get the selected month value and cart ID
                var selectedMonth = $(this).val();
                console.log(selectedMonth);
                var cartId = $(this).data('cart-id');
                console.log(cartId);
                $.ajax({
                    url: "{{ route('customer.checkOutProcess') }}",
                    method: 'POST',
                    data: {
                        month: selectedMonth,
                        cart_id: cartId,
                        _token: "{{ csrf_token() }}"
                    },
                    success: function(response) {
                        console.log(response);
                        toastr.success(response.message, 'Success');
                        // Update the HTML on the page with the updated data
                        $('#updated-amount').html(response.data.totalAmount);
                    }
                });

                // Calculate the total amount for the selected cart
                var rentAmount = $('#rent-amount-' + cartId).text().replace(/[^\d]/g,
                    ''); // remove non-numeric characters from rent amount
                var totalAmount = rentAmount * selectedMonth;
                $('#total-amount-' + cartId).text('৳' + totalAmount);

                // Calculate the grand total amount for all carts
                var grandTotal = 0;
                $('.total-amount').each(function() {
                    var totalAmount = $(this).text().replace(/[^\d]/g,
                        ''); // remove non-numeric characters from total amount
                    grandTotal += parseInt(totalAmount);
                });
                $('#grand-total').text('৳' + grandTotal);
            });
        });
    </script>
@endsection
