@extends('frontend.layouts.master')


@section('content')
    <!-- checkout_wrapper_area::start   -->
    <div class="checkout_v3_area">
        <div class="checkout_v3_left d-flex justify-content-end">
            <div class="checkout_v3_inner">
                {{-- <div class="checout_head_title d-flex align-items-center ">
                                                <span class="flex-fill">5 ITEM(S)</span>
                                                <span>PRICE</span>
                                            </div>
                <div class="checkout_shiped_box">
                   <div class="checout_shiped_head flex-wrap d-flex align-items-center ">
                                                    <span class="package_text flex-fill">Package 2 of 4</span>
                                                    <p><span class="Shipped_text">Shipped by</span> <span class="name_text">OnestTech</span></p>
                                                </div>
                    <div class="checout_shiped_products">
                        <div class="table-responsive mb-0">
                                <table class="table o_landy_table3 style3 mb-5">
                                    <thead>
                                        <tr>
                                            <th class="text-nowrap">{{ _trans('landlord.ITEM(S)') }}</th>
                                            <th class="text-nowrap">{{ _trans('landlord.Unit Price') }}</th>
                                            <th class="text-nowrap">{{ _trans('landlord.Duration') }}</th>
                                            <th class="text-nowrap">{{ _trans('landlord.Price') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($data['carts'] as $cart)
                                            <tr class="cart-row">
                                                <td>
                                                    <a href="{{ @route('properties.details') }}"
                                                        class="d-flex align-items-center gap_20">
                                                        <div class="thumb cart_img overflow-hidden">
                                                            <img class="img-fluid  "
                                                                src="{{ url($cart->property->defaultImage->path) }}"
                                                                alt="">
                                                        </div>
                                                        <div class="summery_pro_content">
                                                            <h4 class="font_16 f_w_700 text-nowrap m-0 theme_hover">
                                                                {{ @$cart->property->name }}</h4>
                                                            <p class="font_14 f_w_400 m-0 ">
                                                                {{ @$cart->property->category->name }}</p>
                                                            <div class="d-flex flex-wrap gap-1 ">
                                                                <span
                                                                    class="body_text d-flex gap_6 align-items-center justify-content-center font_14"><i
                                                                        class="fas fa-bed fw-bolder body_text"></i>{{ @$cart->property->bedroom }}
                                                                    {{ _trans('landlord.Bed') }}</span>
                                                                <span
                                                                    class="body_text d-flex gap_6 align-items-center justify-content-center font_14"><i
                                                                        class="far fa-bath fw-bolder body_text"></i>{{ @$cart->property->bathroom }}
                                                                    {{ _trans('landlord.bath') }}</span>
                                                                <span
                                                                    class="body_text d-flex gap_6 align-items-center justify-content-center font_14"><i
                                                                        class="far fa-border-all fw-bolder body_text"></i>{{ @$cart->property->size }}
                                                                    {{ _trans('landlord.sqft') }}</span>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </td>
                                                <td>
                                                    <h4 class="font_16 f_w_500 m-0 text-nowrap rent-amount"
                                                        id="rent-amount-{{ $cart->id }}">
                                                        ৳{{ @$cart->property->rent_amount }}</h4>
                                                </td>
                                                <td>
                                                    <div class="lag_select">
                                                        <select class="o_land_select6 min_100 wide"
                                                            data-cart-id="{{ $cart->id }}">
                                                            <option value="1">1 month</option>
                                                            <option value="3">3 months</option>
                                                            <option value="6">6 months</option>
                                                            <option value="12">12 months</option>
                                                        </select>

                                                    </div>
                                                </td>
                                                <td>
                                                    <h4 class="font_16 f_w_500 m-0 text-nowrap total-amount"
                                                        id="total-amount-{{ $cart->id }}">
                                                        ৳{{ $cart->property->rent_amount }}</h4>
                                                </td>

                                            </tr>
                                        @empty
                                            <tr>
                                                <p class="py-5 text-center">{{ _trans('landlord.No property found') }}</p>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                        </div>
                    </div>
                </div> --}}
                <div class="shiping_address_box checkout_form m-0">
                    <div class="billing_address">
                        <form action="{{ route('customer.placeOrder') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <h3 class="check_v3_title mb_25">{{ _trans('landlord.Billing Address') }}</h3>
                                <div class="accordion" id="accordionExample">
                                    <div class="accordion-item mb-3">
                                        <h2 class="accordion-header" id="address">

                                            <button class="accordion-button collapsed" type="button"
                                                data-bs-toggle="collapse" data-bs-target="#collapseAddress"
                                                aria-expanded="false" aria-controls="collapseAddress">
                                                {{ _trans('landlord.Add Address') }}
                                            </button>
                                        </h2>
                                        <div id="collapseAddress" class="accordion-collapse collapse"
                                            aria-labelledby="address" data-bs-parent="#accordionExample">
                                            <input type="hidden" name="new_address">
                                            <div class="accordion-body">
                                                <div class="col-lg-12 mb_20">
                                                    <label
                                                        class="primary_label2 style3">{{ _trans('landlord.Name') }}</label>
                                                    <input class="primary_input3 style5 radius_3px " type="text"
                                                        placeholder="{{ _trans('landlord.Enter your first and last name') }}"
                                                        name="name" value="{{ old('name') }}">
                                                    @error('name')
                                                        <small class="text-danger">{{ $message }}</small>
                                                    @enderror
                                                </div>
                                                <div class="col-lg-6 mb_20">
                                                    <label
                                                        class="primary_label2 style3">{{ _trans('landlord.Phone') }}</label>
                                                    <input class="primary_input3 style5 radius_3px" type="number"
                                                        placeholder="{{ _trans('landlord.154327') }}" name="phone">
                                                    @error('phone')
                                                        <small class="text-danger">{{ $message }}</small>
                                                    @enderror
                                                </div>
                                                <div class="col-lg-6 mb_20">
                                                    <label
                                                        class="primary_label2 style3">{{ _trans('landlord.Email') }}</label>
                                                    <input class="primary_input3 style5 radius_3px" type="email"
                                                        placeholder="{{ _trans('landlord.154327') }}" name="email">
                                                    @error('email')
                                                        <small class="text-danger">{{ $message }}</small>
                                                    @enderror
                                                </div>
                                                <div class="col-lg-12 mb_20">
                                                    <label
                                                        class="primary_label2 style3">{{ _trans('landlord.Address') }}</label>
                                                    <input class="primary_input3 style5 radius_3px " type="text"
                                                        placeholder="{{ _trans('landlord.House# 122, Street# 245, ABC Road') }}"
                                                        name="address" value="{{ old('address') }}">
                                                    @error('address')
                                                        <small class="text-danger">{{ $message }}</small>
                                                    @enderror
                                                </div>
                                                <div class="col-lg-6 mb_20">
                                                    <label
                                                        class="primary_label2 style3">{{ _trans('landlord.Country') }}</label>
                                                    <select class="form-select style5 primary_input3"
                                                        aria-label="Default select example" name="country">
                                                        <option class="primary_input3" value="">
                                                            {{ _trans('landlord.Select Country') }}</option>
                                                        @foreach ($data['country'] as $country)
                                                            <option value="{{ $country->id }}">{{ $country->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                    @error('country')
                                                        <small class="text-danger">{{ $message }}</small>
                                                    @enderror
                                                </div>
                                                <div class="col-lg-6 mb_20">
                                                    <label
                                                        class="primary_label2 style3">{{ _trans('landlord.Postal Code') }}</label>
                                                    <input class="primary_input3 style5 radius_3px" type="number"
                                                        placeholder="{{ _trans('landlord.154327') }}" name="postal">
                                                    @error('postal')
                                                        <small class="text-danger">{{ $message }}</small>
                                                    @enderror
                                                </div>

                                                <div class="col-12 mb_25">
                                                    <label class="primary_checkbox d-flex">
                                                        <input type="checkbox" name="terms_and_condition">
                                                        <span class="checkmark mr_15"></span>
                                                        <span
                                                            class="label_name f_w_400 ">{{ _trans('landlord.I agree with the terms and conditions.') }}</span>

                                                    </label>
                                                    @error('terms_and_condition')
                                                        <small class="text-danger">{{ $message }}</small>
                                                    @enderror
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                @if ($data['address']->count() > 0)
                                    @foreach ($data['address'] as $key => $address)
                                        <label class="aiz-megabox d-block bg-white">
                                            <span class="d-flex p-3 gap-2 address-box">
                                                <input type="radio" name="billing_address_id" value="{{ $address->id }}">
                                                <span class=" flex-shrink-0 mt-1"></span>
                                                <span class="flex-grow-1 pl-3 text-left line-break">
                                                    <div> <span class="w-50 fw-600">Name:</span>
                                                        <span class="ml-2">{{ $address->name }}</span>
                                                    </div>
                                                    <div> <span class="w-50 fw-600">Phone:</span>
                                                        <span class="ml-2">{{ $address->phone }}</span>
                                                    </div>
                                                    <div> <span class="w-50 fw-600">Address:</span>
                                                        <span class="ml-2">{{ $address->address }}</span>
                                                    </div>
                                                </span>
                                            </span>
                                        </label>
                                    @endforeach
                                @else
                                    <p>No address found for this user.</p>
                                @endif

                                {{-- <div class="col-12">
                                    <div class="check_v3_btns flex-wrap d-flex align-items-center">
                                        <button type="submit"
                                            class="o_land_primary_btn style2  min_200 text-center text-uppercase ">{{ _trans('landlord.Continue to shipping') }}</button>
                                        <a href="{{ route('customer.cart') }}"
                                            class="return_text">{{ _trans('landlord.Return to cart') }}</a>
                                    </div>
                                </div> --}}
                            </div>

                            <div class="row">
                                <div class="col-12 mb_10">
                                    <h3 class="check_v3_title2">Payment</h3>
                                    <h6 class="shekout_subTitle_text">All transactions are secure and encrypted.</h6>
                                </div>
                                <div class="col-12">
                                    <div class="accordion checkout_acc_style mb_30" id="accordionExample">
                                        <div class="accordion-item">
                                            {{-- <div class="accordion-header" id="headingOne">
                                                <span class="accordion-button shadow-none" data-bs-toggle="collapse"
                                                    data-bs-target="#collapseOne" aria-controls="collapseOne">
                                                    <span>
                                                        <label class="primary_checkbox d-inline-flex style5 gap_10">
                                                            <input name="card" type="radio">
                                                            <span class="checkmark m-0"></span>
                                                            <span class="label_name f_w_500 ">Credit card</span>
                                                        </label>
                                                    </span>
                                                </span>
                                            </div>
                                            <div id="collapseOne" class="accordion-collapse collapse"
                                                aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                                <div class="accordion-body">
                                                    <!-- content ::start  -->
                                                    <form action="#" name="#">
                                                        <div class="row">
                                                            <div class="col-lg-12">
                                                                <label class="primary_label2 style3">Card Number</label>
                                                                <input class="primary_input3 style4 radius_3px mb_20"
                                                                    type="text"
                                                                    placeholder="xxxx - xxxx - xxxx - xxxx">
                                                            </div>
                                                            <div class="col-lg-12">
                                                                <label class="primary_label2 style3">Name on Card</label>
                                                                <input class="primary_input3 style4 radius_3px mb_20"
                                                                    type="text" placeholder="Robert Downey JR">
                                                            </div>
                                                            <div class="col-lg-6">
                                                                <label class="primary_label2 style3">Expiration Date
                                                                    (MM/YY)</label>
                                                                <input class="primary_input3 style4 radius_3px mb_20"
                                                                    type="text" placeholder="12 / 2026">
                                                            </div>
                                                            <div class="col-lg-6">
                                                                <label class="primary_label2 style3">Security Code</label>
                                                                <input class="primary_input3 style4 radius_3px mb_20"
                                                                    type="text" placeholder="Robert Downey JR">
                                                            </div>
                                                        </div>
                                                    </form>
                                                    <!-- content ::end  -->
                                                </div>
                                            </div> --}}
                                        </div>
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingTwo">
                                                <span class="accordion-button shadow-none collapsed">
                                                    <span>
                                                        <label class="primary_checkbox d-inline-flex style5 gap_10">
                                                            <input name="payment_method" value="cash_on_delivery"
                                                                type="radio" checked>
                                                            <span class="checkmark m-0"></span>
                                                            <span class="label_name f_w_500 ">
                                                                Cash on Delivery (COD)
                                                            </span>
                                                        </label>
                                                    </span>
                                                </span>
                                            </h2>
                                        </div>
                                        {{-- <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingThree">
                                                <span class="accordion-button shadow-none collapsed"
                                                    data-bs-toggle="collapse" data-bs-target="#collapseThree"
                                                    aria-controls="collapseThree">
                                                    <label class="primary_checkbox d-inline-flex style5 gap_10">
                                                        <input name="card" type="radio">
                                                        <span class="checkmark m-0"></span>
                                                        <span class="label_name f_w_500 ">
                                                            Paypal
                                                        </span>
                                                    </label>
                                                </span>
                                            </h2>
                                            <div id="collapseThree" class="accordion-collapse collapse"
                                                aria-labelledby="headingThree" data-bs-parent="#accordionExample">
                                                <div class="accordion-body">
                                                    <!-- content ::start  -->
                                                    <form action="#" name="#">
                                                        <div class="row">
                                                            <div class="col-lg-12">
                                                                <label class="primary_label2 style3">Card Number</label>
                                                                <input class="primary_input3 style4 radius_3px mb_20"
                                                                    type="text"
                                                                    placeholder="xxxx - xxxx - xxxx - xxxx">
                                                            </div>
                                                            <div class="col-lg-12">
                                                                <label class="primary_label2 style3">Name on Card</label>
                                                                <input class="primary_input3 style4 radius_3px mb_20"
                                                                    type="text" placeholder="Robert Downey JR">
                                                            </div>
                                                            <div class="col-lg-6">
                                                                <label class="primary_label2 style3">Expiration Date
                                                                    (MM/YY)</label>
                                                                <input class="primary_input3 style4 radius_3px mb_20"
                                                                    type="text" placeholder="12 / 2026">
                                                            </div>
                                                            <div class="col-lg-6">
                                                                <label class="primary_label2 style3">Security Code</label>
                                                                <input class="primary_input3 style4 radius_3px mb_20"
                                                                    type="text" placeholder="Robert Downey JR">
                                                            </div>
                                                        </div>
                                                    </form>
                                                    <!-- content ::end  -->
                                                </div>
                                            </div>
                                        </div>
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingThree1">
                                                <span class="accordion-button shadow-none collapsed"
                                                    data-bs-toggle="collapse" data-bs-target="#collapseThree1"
                                                    aria-controls="collapseThree1">
                                                    <label class="primary_checkbox d-inline-flex style5 gap_10">
                                                        <input name="card" type="radio">
                                                        <span class="checkmark m-0"></span>
                                                        <span class="label_name f_w_500 ">
                                                            Stripe
                                                        </span>
                                                    </label>
                                                </span>
                                            </h2>
                                            <div id="collapseThree1" class="accordion-collapse collapse"
                                                aria-labelledby="headingThree1" data-bs-parent="#accordionExample">
                                                <div class="accordion-body">
                                                    <!-- content ::start  -->
                                                    <form action="#" name="#">
                                                        <div class="row">
                                                            <div class="col-lg-12">
                                                                <label class="primary_label2 style3">Card Number</label>
                                                                <input class="primary_input3 style4 radius_3px mb_20"
                                                                    type="text"
                                                                    placeholder="xxxx - xxxx - xxxx - xxxx">
                                                            </div>
                                                            <div class="col-lg-12">
                                                                <label class="primary_label2 style3">Name on Card</label>
                                                                <input class="primary_input3 style4 radius_3px mb_20"
                                                                    type="text" placeholder="Robert Downey JR">
                                                            </div>
                                                            <div class="col-lg-6">
                                                                <label class="primary_label2 style3">Expiration Date
                                                                    (MM/YY)</label>
                                                                <input class="primary_input3 style4 radius_3px mb_20"
                                                                    type="text" placeholder="12 / 2026">
                                                            </div>
                                                            <div class="col-lg-6">
                                                                <label class="primary_label2 style3">Security Code</label>
                                                                <input class="primary_input3 style4 radius_3px mb_20"
                                                                    type="text" placeholder="Robert Downey JR">
                                                            </div>
                                                        </div>
                                                    </form>
                                                    <!-- content ::end  -->
                                                </div>
                                            </div>
                                        </div> --}}
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="check_v3_btns flex-wrap d-flex align-items-center">
                                        <button type="submit"
                                            class="o_land_primary_btn style2  min_200 text-center text-uppercase ">Place
                                            Order</button>
                                        <a href="#" class="return_text">Return to shipping</a>
                                    </div>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
        <div class="checkout_v3_right d-flex justify-content-start">
            <div class="order_sumery_box flex-fill">
                <h3 class="check_v3_title mb_25">{{ _trans('landlord.Order Summary') }}</h3>
                <div class="subtotal_lists">
                    @php
                        $total = 0;
                    @endphp
                    @forelse($data['carts'] as $cart)
                        <div class="single_total_list d-flex align-items-center">
                            <div class="single_total_left flex-fill">
                                <h4>{{ _trans('landlord.Subtotal') }}</h4>
                            </div>
                            <div class="single_total_right">
                                <span> ৳ {{ @$cart->durations * @$cart->property->rent_amount }}</span>
                            </div>
                        </div>
                        <div class="single_total_list d-flex align-items-center flex-wrap">
                            <div class="single_total_left flex-fill">
                                <h4>{{ _trans('landlord.Shipping Charge') }}</h4>
                                <p>Package Wise Shipping Charge</p>
                            </div>
                            <div class="single_total_right">
                                <span> ৳ {{ @$cart->property->location->upazila->charge }}</span>
                            </div>
                        </div>
                        <div class="single_total_list d-flex align-items-center flex-wrap">
                            <div class="single_total_left flex-fill">
                                <h4>{{ _trans('landlord.Discount') }}</h4>
                            </div>
                            <div class="single_total_right">
                                <span>৳ {{ @$cart->property->discount_amount }}</span>
                            </div>
                        </div>
                        <div class="total_amount d-flex align-items-center flex-wrap mb_25">
                            <div class="single_total_left flex-fill">
                                <span class="total_text">{{ _trans('landlord.Sub Total') }} (Incl. VAT)</span>
                            </div>
                            <div class="single_total_right">
                                <span class="total_text"> <span>৳ {{ (@$cart->durations * @$cart->property->rent_amount) + @$cart->property->location->upazila->charge + @$cart->property->discount_amount }}</span></span>
                            </div>
                        </div>

                        @php
                            $total += (@$cart->durations * @$cart->property->rent_amount) + @$cart->property->location->upazila->charge + @$cart->property->discount_amount
                        @endphp
                    @empty
                        <p>{{ _trans('landlord.No property found') }}</p>
                    @endforelse
                    <div class="total_amount d-flex align-items-center flex-wrap mb_25">
                        <div class="single_total_left flex-fill">
                            <span class="total_text">{{ _trans('landlord.Total') }} (Incl. VAT)</span>
                        </div>
                        <div class="single_total_right">
                            <span class="total_text"> <span>৳ {{ $total }}</span></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>


    </div>
    <!-- checkout_wrapper_area::end   -->
@endsection

@section('script')
    <script>
        $(document).ready(function() {
            // Listen to changes in the select element
            $('.o_land_select6').on('change', function() {
                // Get the selected month value and cart ID
                var selectedMonth = $(this).val();
                console.log(selectedMonth);
                var cartId = $(this).data('cart-id');
                console.log(cartId);
                $.ajax({
                    url: "{{ route('customer.checkOutProcess') }}",
                    method: 'POST',
                    data: {
                        month: selectedMonth,
                        cart_id: cartId,
                        _token: "{{ csrf_token() }}"
                    },
                    success: function(response) {
                        console.log(response);
                        toastr.success(response.message, 'Success');
                        // Update the HTML on the page with the updated data
                        $('#updated-amount').html(response.data.totalAmount);
                    }
                });

                // Calculate the total amount for the selected cart
                var rentAmount = $('#rent-amount-' + cartId).text().replace(/[^\d]/g,
                    ''); // remove non-numeric characters from rent amount
                var totalAmount = rentAmount * selectedMonth;
                $('#total-amount-' + cartId).text('৳' + totalAmount);

                // Calculate the grand total amount for all carts
                var grandTotal = 0;
                $('.total-amount').each(function() {
                    var totalAmount = $(this).text().replace(/[^\d]/g,
                        ''); // remove non-numeric characters from total amount
                    grandTotal += parseInt(totalAmount);
                });
                $('#grand-total').text('৳' + grandTotal);
            });
        });
    </script>
@endsection
