<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\ManagerController;
use App\Http\Controllers\Backend\AboutController;
use App\Http\Controllers\Frontend\HomeController;
use App\Http\Controllers\Customer\CustomerController;
use App\Http\Controllers\Backend\AuthenticationController;
use App\Http\Controllers\PageController;
use App\Models\Page;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */

include_route_files(__DIR__ . '/Admin/');
include_route_files(__DIR__ . '/Customer/');
include_route_files(__DIR__ . '/Frontend/');
// Auth::routes();

Route::get('-reset-my-database', [ManagerController::class, 'index'])->name('i-am-sure-to-reset-my-database');

Route::group(['middleware' => ['XssSanitizer', 'lang', 'not.auth.routes']], function () {

    Route::controller(AuthenticationController::class)->group(function () {
        Route::get('login', 'loginPage')->name('login');
        Route::post('login', 'login')->name('login.auth');
        Route::get('register', 'registerPage')->name('register');
        Route::post('register', 'register')->name('register');
        Route::get('verify-email/{email}/{token}', 'verifyEmail')->name('verify-email');

        // reset password
        Route::get('forgot-password', 'forgotPasswordPage')->name('forgot-password');
        Route::post('forgot-password', 'forgotPassword')->name('forgot.password');

        Route::get('reset-password/{email}/{token}', 'resetPasswordPage')->name('reset-password');
        Route::post('reset-password', 'resetPassword')->name('reset.password');
    });

});

// Frontend routes
Route::get('/', [HomeController::class, 'index'])->name('home');

// User routes
Route::get('/order-tracking', [HomeController::class, 'orderTracking'])->name('orderTracking');
Route::get('/wishlist', [HomeController::class, 'wishlist'])->name('wishlist');

// Informational routes
Route::get('/about', [AboutController::class, 'about'])->name('about');
Route::get('/contact', [ContactController::class, 'contact'])->name('contact');
Route::post('contact/store', [ContactController::class, 'store'])->name('contact.store');
Route::get('/faq', [HomeController::class, 'faq'])->name('faq');
Route::get('/terms', [HomeController::class, 'terms'])->name('terms');
Route::get('/privacy', [HomeController::class, 'privacy'])->name('privacy');
Route::get('/error', [HomeController::class, 'error'])->name('error');

// Properties routes
// // Route::get('/properties', [HomeController::class, 'properties'])->name('properties');
// Route::get('/property-details', [HomeController::class, 'propertyDetails'])->name('properties.details');

// Blog routes
Route::prefix('blogs')->group(function () {
    Route::get('/', [HomeController::class, 'blogs'])->name('blogs');
    Route::get('/details/{slug}', [HomeController::class, 'blogDetails'])->name('blogDetails');
    Route::post('/blogs-review/{blogId}', [HomeController::class, 'blogReview'])->name('blogReview');
});



// START:: Category Routes
Route::get('/category/{slug}', [HomeController::class, 'categoryWiseProperties'])->name('categoryWiseProperties');

Route::get('{slug}', [PageController::class, 'index']);

// END:: Category Routes
